<?php
header("Content-Type: application/json; charset=UTF-8");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'src/Exception.php';
require 'src/PHPMailer.php';
require 'src/SMTP.php';
require_once 'config.php';

// A simple logging function
function write_log($message) {
    file_put_contents('email_debug.log', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

write_log("--- New Email Alert Request ---");

$data = json_decode(file_get_contents("php://input"));
write_log("Received Payload: " . json_encode($data));

if (!isset($data->house_id) || !isset($data->visitor_name)) {
    $error_msg = "Missing required fields.";
    write_log("Validation Error: " . $error_msg);
    echo json_encode(["status" => "error", "message" => $error_msg]);
    exit();
}

$conn = getDbConnection();
write_log("Database connection successful.");

$house_id = $data->house_id;
$stmt = $conn->prepare("SELECT alert_email FROM houses WHERE id = ?");
$stmt->bind_param("i", $house_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $to_email = $row['alert_email'];
    write_log("Found recipient email: " . $to_email);
    
    $mail = new PHPMailer(true);

    try {
        // --- MODIFIED: Server settings now for your cPanel email ---
        write_log("Configuring PHPMailer for cPanel SMTP...");
        $mail->isSMTP();
        
        // Use the Outgoing Server address from your cPanel settings
        $mail->Host       = 'mail.parkspace.co.ke'; // Replace if yours is different
        $mail->SMTPAuth   = true;
        
        // --- IMPORTANT: Use the credentials for your domain email account ---
        $mail->Username   = 'guestpass@parkspace.co.ke'; // The full email address
        $mail->Password   = 'Shemking@18';    // The password for that email account
        
        // Use the Port and Encryption from your cPanel "Secure SSL/TLS Settings"
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use 'tls' if your port is 587
        $mail->Port       = 465;                        // Use 587 if your encryption is TLS

        // --- Recipients and Content ---
        $mail->setFrom('guestpass@parkspace.co.ke', 'GuestPass VMS Alert');
        $mail->addAddress($to_email); 

        $mail->isHTML(true);
        $mail->Subject = "Visitor Alert: " . htmlspecialchars($data->visitor_name) . " is at the Gate";
        
        $message = "<html><body>";
        $message .= "<h2>Visitor Arrival Notification</h2>";
        $message .= "<p><strong>Visitor Name:</strong> " . htmlspecialchars($data->visitor_name) . "</p>";
        $message .= "<p><strong>Description:</strong> " . htmlspecialchars($data->visitor_description) . "</p>";
        $message .= "<p><strong>Admitted By (Guard):</strong> " . htmlspecialchars($data->admitted_by) . "</p>";
        $message .= "<p><strong>Visitor Phone:</strong> " . htmlspecialchars($data->visitor_phone ?? 'N/A') . "</p>";
        $message .= "<hr>";
        $message .= "<h3><strong>Exit Code:</strong> " . htmlspecialchars($data->otp) . "</h3>";
        $message .= "<p>Please provide this code to the visitor for when they exit.</p>";
        $message .= "</body></html>";
        
        $mail->Body    = $message;
        
        write_log("Attempting to send email via cPanel SMTP...");
        $mail->send();
        
        $success_msg = "Alert email sent successfully to " . $to_email;
        write_log($success_msg);
        echo json_encode(["status" => "success", "message" => $success_msg]);

    } catch (Exception $e) {
        $error_msg = "Email could not be sent. Mailer Error: {$mail->ErrorInfo}";
        write_log("PHPMailer Exception: " . $error_msg);
        echo json_encode(["status" => "error", "message" => $error_msg]);
    }

} else {
    // ... error handling ...
}

$stmt->close();
$conn->close();
?>