<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . '/config.php';

$conn = getDbConnection();

function out_json($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data);
    exit();
}

// Query params (all optional)
$search = isset($_GET['search']) ? trim((string)$_GET['search']) : '';
$orgId  = null;
if (isset($_GET['organisation_id']) && $_GET['organisation_id'] !== '') {
    $orgId = (int) $_GET['organisation_id'];
} elseif (isset($_GET['org_id']) && $_GET['org_id'] !== '') { // legacy key
    $orgId = (int) $_GET['org_id'];
}

$limit  = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
if ($limit <= 0)  $limit = 50;
if ($limit > 200) $limit = 200;
if ($offset < 0)  $offset = 0;

// Build WHERE clause dynamically
$clauses = [];
$params  = [];
$types   = "";

// Optional organisation scope
if ($orgId) {
    $clauses[] = "organisation_id = ?";
    $types    .= "i";
    $params[]  = $orgId;
}

// Optional search across real_name and username
if ($search !== '') {
    $clauses[] = "(real_name LIKE ? OR username LIKE ?)";
    $types    .= "ss";
    $like = "%{$search}%";
    $params[] = $like;
    $params[] = $like;
}

$where = "";
if ($clauses) {
    $where = "WHERE " . implode(" AND ", $clauses);
}

$sql = "SELECT user_id, real_name, username
        FROM users
        $where
        ORDER BY created_at DESC, user_id DESC
        LIMIT ? OFFSET ?";

$types   .= "ii";
$params[] = $limit;
$params[] = $offset;

$stmt = $conn->prepare($sql);
if (!$stmt) {
    out_json(["success" => false, "message" => "Database error (prepare)"], 500);
}

$stmt->bind_param($types, ...$params);
$stmt->execute();

$res   = $stmt->get_result();
$users = [];
while ($row = $res->fetch_assoc()) {
    $users[] = [
        "user_id"   => (int)$row["user_id"],
        "real_name" => $row["real_name"],
        "username"  => $row["username"],
    ];
}

$stmt->close();
$conn->close();

// Return raw array (compat)
out_json($users, 200);
