<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'config.php';
$conn = getDbConnection();

if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

// Close connection gracefully
register_shutdown_function(function() use ($conn) {
    if ($conn) {
        $conn->close();
    }
});

// ✅ REQUIRED: Organisation ID
$orgId = isset($_GET['organisation_id']) ? intval($_GET['organisation_id']) : 0;
if ($orgId === 0) {
    echo json_encode(["status" => "error", "message" => "Missing organisation ID"]);
    exit();
}

// ✅ Optional date filtering
$startDate = isset($_GET['start_date']) ? $conn->real_escape_string($_GET['start_date']) : null;
$endDate = isset($_GET['end_date']) ? $conn->real_escape_string($_GET['end_date']) : null;

// ✅ WHERE clause with org filtering
$whereClause = "WHERE vr.organisation_id = $orgId";
if ($startDate && $endDate) {
    $whereClause .= " AND vr.created_at BETWEEN '$startDate 00:00:00' AND '$endDate 23:59:59'";
}

// ✅ Fetch analytics records scoped to org
$query = "SELECT vr.id, vr.house_id, h.house_number, vr.description, vr.name, 
                 vr.phone_number, vr.image_metadata, vr.id_plates, vr.admitted_by, 
                 vr.created_at, vr.otp_code, vr.is_exited 
          FROM visitor_records vr 
          LEFT JOIN houses h ON vr.house_id = h.id 
          $whereClause
          ORDER BY vr.created_at DESC";

$result = $conn->query($query);
if (!$result) {
    echo json_encode(["status" => "error", "message" => "Query failed"]);
    exit();
}

// ✅ Build response
$visitors = [];
while ($row = $result->fetch_assoc()) {
    $row['is_exited'] = (int)$row['is_exited'];
    $visitors[] = $row;
}

echo json_encode([
    "status" => "success",
    "total_fetched" => count($visitors),
    "visitor_records" => $visitors
]);
exit();
?>
