<?php
// guardianapi/org_list.php
declare(strict_types=1);

if (!isset($GLOBALS['AUTH'])) { http_response_code(401); echo json_encode(['status'=>'error','message'=>'Unauthorized']); exit; }

require_once __DIR__ . '/config.php';
$conn = getDbConnection();

$rows = [];
$sql = "
  SELECT
    o.organisation_id         AS id,
    o.organisation_name       AS name,
    o.contact_name,
    o.contact_email,
    o.contact_phone,
    o.is_active,
    o.expiry,
    o.created_at,
    a.admin_id,
    a.username                AS admin_username
  FROM organisations o
  LEFT JOIN (
    SELECT x.admin_id, x.organisation_id, x.username
    FROM admin x
    JOIN (
      SELECT MIN(admin_id) AS min_id, organisation_id
      FROM admin WHERE is_active=1 GROUP BY organisation_id
    ) pick ON pick.min_id = x.admin_id
  ) a ON a.organisation_id=o.organisation_id
  ORDER BY o.organisation_id ASC";
if ($res=$conn->query($sql)){
  while($r=$res->fetch_assoc()){
    $r['is_active']=(int)$r['is_active'];
    $rows[]=$r;
  }
  $res->close();
}
echo json_encode(['status'=>'success','organisations'=>$rows]);
