<?php
require __DIR__.'/config.php';
date_default_timezone_set('Africa/Nairobi');

header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD']==='OPTIONS'){http_response_code(204);exit;}

function pdo(): PDO { if(isset($GLOBALS['pdo'])&&$GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo']; return getPdoConnection(); }
function assert_admin(PDO $pdo,string $token){ $q=$pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1"); $q->execute([$token]); if(!$q->fetchColumn()){ http_response_code(401); echo json_encode(['success'=>false,'message'=>'Admin token required']); exit; } }

$authz=$_SERVER['HTTP_AUTHORIZATION']??''; $token=preg_replace('/^Bearer\s+/i','',$authz);
if(!$token){http_response_code(401);echo json_encode(['success'=>false,'message'=>'Missing token']);exit;}
$pdo=pdo(); assert_admin($pdo,$token);

$in=json_decode(file_get_contents('php://input'),true)?:[];
$id     = isset($in['id'])?(int)$in['id']:0;
$org_id = (int)($in['org_id']??0);
$name   = trim($in['name']??'');
$start  = trim($in['start_time']??'');
$end    = trim($in['end_time']??'');
$tin    = (int)($in['tolerance_in_mins']??0);
$tout   = (int)($in['tolerance_out_mins']??0);

if(!$org_id||$name===''||$start===''||$end===''){ http_response_code(422); echo json_encode(['success'=>false,'message'=>'Missing fields']); exit; }

if($id>0){
  $q=$pdo->prepare("UPDATE shifts SET name=?, start_time=?, end_time=?, tolerance_in_mins=?, tolerance_out_mins=? WHERE id=? AND org_id=?");
  $q->execute([$name,$start,$end,$tin,$tout,$id,$org_id]);
} else {
  $q=$pdo->prepare("INSERT INTO shifts (org_id,name,start_time,end_time,tolerance_in_mins,tolerance_out_mins) VALUES (?,?,?,?,?,?)");
  $q->execute([$org_id,$name,$start,$end,$tin,$tout]);
  $id=(int)$pdo->lastInsertId();
}

echo json_encode(['success'=>true,'id'=>$id,'message'=>'Saved']);
