<?php
require __DIR__.'/config.php';
date_default_timezone_set('Africa/Nairobi');

header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if($_SERVER['REQUEST_METHOD']==='OPTIONS'){http_response_code(204);exit;}

function pdo(): PDO { if(isset($GLOBALS['pdo'])&&$GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo']; return getPdoConnection(); }
function assert_admin(PDO $pdo,string $token){
  $q=$pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1"); $q->execute([$token]);
  if(!$q->fetchColumn()){ http_response_code(401); echo json_encode(['success'=>false,'message'=>'Admin token required']); exit; }
}

$authz=$_SERVER['HTTP_AUTHORIZATION']??''; $token=preg_replace('/^Bearer\s+/i','',$authz);
if(!$token){http_response_code(401);echo json_encode(['success'=>false,'message'=>'Missing token']);exit;}
$pdo=pdo(); assert_admin($pdo,$token);

$org_id=(int)($_GET['org_id']??0);
$start = $_GET['start'] ?? date('Y-m-01'); // default: this month
$end   = $_GET['end']   ?? date('Y-m-d');
$site_id = isset($_GET['site_id'])?(int)$_GET['site_id']:null;
$user_id = isset($_GET['user_id'])?(int)$_GET['user_id']:null;

if(!$org_id){ http_response_code(422); echo json_encode(['success'=>false,'message'=>'org_id required']); exit; }

$params = [':org'=>$org_id, ':start'=>$start.' 00:00:00', ':end'=>$end.' 23:59:59'];
$sql = "
SELECT s.id, s.user_id, s.org_id, s.site_id,
       s.clock_in_tag, s.clock_in_time, s.clock_out_tag, s.clock_out_time,
       u.real_name, st.site_name
FROM book_sessions s
LEFT JOIN users u ON u.user_id = s.user_id
LEFT JOIN sites st ON st.site_id = s.site_id
WHERE s.org_id = :org
  AND s.clock_in_time BETWEEN :start AND :end
";
if($site_id){ $sql.=" AND s.site_id = :sid"; $params[':sid']=$site_id; }
if($user_id){ $sql.=" AND s.user_id = :uid"; $params[':uid']=$user_id; }
$sql .= " ORDER BY s.clock_in_time DESC";

$sth=$pdo->prepare($sql); $sth->execute($params);
$sessions=$sth->fetchAll();

$sh=$pdo->prepare("SELECT * FROM shifts WHERE org_id=? AND active=1 ORDER BY start_time");
$sh->execute([$org_id]);
$shifts=$sh->fetchAll();

function dt($s){ return $s? new DateTime($s) : null; }
function mins($a,$b){ return (int)round(($a->getTimestamp()-$b->getTimestamp())/60); }
function match_shift(array $shifts, DateTime $cin): ?array {
  // choose the shift whose scheduled window (today or overnight) contains cin, else nearest by start delta
  $best=null; $bestAbs=PHP_INT_MAX;
  foreach($shifts as $sh){
    $start = DateTime::createFromFormat('Y-m-d H:i:s', $cin->format('Y-m-d').' '.$sh['start_time']);
    $end   = DateTime::createFromFormat('Y-m-d H:i:s', $cin->format('Y-m-d').' '.$sh['end_time']);
    if($end <= $start) $end->modify('+1 day'); // overnight shift

    if($cin >= $start && $cin <= $end){ return $sh + ['sched_start'=>$start,'sched_end'=>$end]; }
    $delta=abs($cin->getTimestamp()-$start->getTimestamp());
    if($delta<$bestAbs){ $bestAbs=$delta; $best=$sh + ['sched_start'=>$start,'sched_end'=>$end]; }
  }
  return $best;
}

$rows=[]; $perUser=[];

$now=new DateTime();
foreach($sessions as $row){
  $cin=dt($row['clock_in_time']); $cout=dt($row['clock_out_time']) ?: $now;
  if(!$cin){ continue; }

  $shift = match_shift($shifts, $cin);
  $late_by=0; $early_by=0; $shift_name=null; $sched_start=null; $sched_end=null;

  if($shift){
    $shift_name = $shift['name'];
    $sched_start = $shift['sched_start'];
    $sched_end   = $shift['sched_end'];

    $tolIn  = (int)$shift['tolerance_in_mins'];
    $tolOut = (int)$shift['tolerance_out_mins'];

    $latest_ok = (clone $sched_start)->modify("+{$tolIn} minutes");
    if($cin > $latest_ok){ $late_by = mins($cin, $latest_ok); }

    $earliest_ok = (clone $sched_end)->modify("-{$tolOut} minutes");
    if($cout < $earliest_ok){ $early_by = mins($earliest_ok, $cout); }
  }

  $duration_min = max(0, mins($cout,$cin));
  $date_key = (new DateTime($row['clock_in_time']))->format('Y-m-d');

  $rows[] = [
    'id' => (int)$row['id'],
    'user_id' => (int)$row['user_id'],
    'real_name' => $row['real_name'] ?: ("User #".$row['user_id']),
    'site_id' => (int)$row['site_id'],
    'site_name' => $row['site_name'],
    'clock_in_time' => $row['clock_in_time'],
    'clock_out_time'=> $row['clock_out_time'],
    'duration_min'  => $duration_min,
    'date'          => $date_key,
    'shift_name'    => $shift_name,
    'scheduled_start'=> $sched_start? $sched_start->format('Y-m-d H:i:s'): null,
    'scheduled_end'  => $sched_end?   $sched_end->format('Y-m-d H:i:s'): null,
    'late_by_min'   => $late_by,
    'early_by_min'  => $early_by
  ];

  // per-user rollup
  $uid=(int)$row['user_id'];
  if(!isset($perUser[$uid])){
    $perUser[$uid]=[
      'user_id'=>$uid,
      'real_name'=>$row['real_name'] ?: ("User #".$uid),
      'days_worked'=>[],
      'minutes_total'=>0,
      'late_total'=>0,
      'early_total'=>0
    ];
  }
  $perUser[$uid]['minutes_total'] += $duration_min;
  $perUser[$uid]['late_total']    += $late_by;
  $perUser[$uid]['early_total']   += $early_by;
  $perUser[$uid]['days_worked'][$date_key] = true;
}

$summary=[];
foreach($perUser as $u){
  $summary[] = [
    'user_id' => $u['user_id'],
    'real_name' => $u['real_name'],
    'days_worked' => count($u['days_worked']),
    'hours_total' => round($u['minutes_total']/60,2),
    'late_minutes_total' => $u['late_total'],
    'early_minutes_total'=> $u['early_total']
  ];
}

echo json_encode([
  'success'=>true,
  'message'=>'OK',
  'sessions'=>$rows,
  'summary'=>$summary,
  'shifts'=>$shifts
]);
