<?php
require 'config.php';
header("Content-Type: application/json");

$conn = getDbConnection();

// ✅ Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'patrol_log_error.log');

// ✅ Read request parameters
$user_id = $_GET['user_id'] ?? null;
$book_on_time = $_GET['book_on_time'] ?? null;

// ✅ Validate required fields
if (!$user_id || !$book_on_time) {
    echo json_encode(["success" => false, "message" => "Missing required parameters"]);
    exit();
}

// ✅ Fetch patrol records
$stmt = $conn->prepare("SELECT tag_name, patrol_time FROM patrols WHERE user_id = ? AND patrol_time >= ?");
$stmt->bind_param("is", $user_id, $book_on_time);
$stmt->execute();
$result = $stmt->get_result();

$patrols = [];
while ($row = $result->fetch_assoc()) {
    $patrols[] = $row;
}

echo json_encode(["success" => true, "patrols" => $patrols]);
$conn->close();
?>
