<?php
require __DIR__ . '/config.php';
date_default_timezone_set('Africa/Nairobi');

// CORS
header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

// PDO provider (backwards-compatible)
function pdo(): PDO {
    if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo'];
    if (function_exists('getPdoConnection')) return getPdoConnection(); // emits JSON 500 & exit on failure
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'DB not configured']); exit;
}

// Auth
function auth(PDO $pdo, string $token): ?array {
    $q = $pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1");
    $q->execute([$token]);
    if ($q->fetchColumn()) return ['role'=>'admin','user_id'=>null];

    $q = $pdo->prepare("SELECT user_id FROM guardusers WHERE token=? LIMIT 1");
    $q->execute([$token]);
    $uid = $q->fetchColumn();
    if ($uid) return ['role'=>'user','user_id'=>(int)$uid];

    return null;
}

// Input + auth
$input = json_decode(file_get_contents('php://input'), true) ?: [];
$authz = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$token = preg_replace('/^Bearer\s+/i', '', $authz);
if (!$token) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Missing token']); exit; }

$pdo = pdo();
$who = auth($pdo, $token);
if (!$who) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Invalid token']); exit; }

// Validate
$user_id = (int)($input['user_id'] ?? 0);
$org_id  = (int)($input['org_id']  ?? 0);
$site_id = (int)($input['site_id'] ?? 0);
$tag     = trim($input['tag'] ?? '');

if ($who['role']==='user' && ($user_id === 0 || $user_id !== $who['user_id'])) {
    http_response_code(403);
    echo json_encode(['success'=>false,'message'=>'Forbidden (mismatched user)']); exit;
}
if (!$user_id || !$org_id || !$site_id || $tag==='') {
    http_response_code(422);
    echo json_encode(['success'=>false,'message'=>'Missing required fields']); exit;
}

// Logic
try {
    $pdo->beginTransaction();

    $chk = $pdo->prepare("SELECT id FROM book_sessions WHERE user_id=? AND clock_out_time IS NULL FOR UPDATE");
    $chk->execute([$user_id]);
    if ($chk->fetch()) {
        $pdo->rollBack();
        http_response_code(409);
        echo json_encode(['success'=>false,'message'=>'You are already clocked in.']); exit;
    }

    $ins = $pdo->prepare("
        INSERT INTO book_sessions (user_id, org_id, site_id, clock_in_tag, clock_in_time)
        VALUES (?,?,?,?, NOW())
    ");
    $ins->execute([$user_id, $org_id, $site_id, $tag]);

    $pdo->commit();
    echo json_encode(['success'=>true,'message'=>'Clock-in successful']);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Server error: '.$e->getMessage()]);
}
