<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json');

$conn = getDbConnection();
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['site_id'], $data['tag_name'], $data['tag_type'], $data['latitude'], $data['longitude'])) {
    $site_id = intval($data['site_id']);
    $tag_name = trim($data['tag_name']);
    $tag_type = $data['tag_type'];
    $latitude = doubleval($data['latitude']);
    $longitude = doubleval($data['longitude']);

    $stmt = $conn->prepare("INSERT INTO nfc_tags (tag_name, site_id, tag_type, latitude, longitude) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sissd", $tag_name, $site_id, $tag_type, $latitude, $longitude);

    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "NFC tag registered"]);
    } else {
        echo json_encode(["success" => false, "message" => $stmt->error]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
}

$conn->close();
?>
