<?php
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$username = $data['username'] ?? '';
$password = $data['password'] ?? '';

if (!$username || !$password) {
    echo json_encode(["status" => "error", "message" => "Username and password are required"]);
    exit();
}

$conn = getDbConnection();

// Fetch user
$stmt = $conn->prepare("SELECT password FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Account not found"]);
    exit();
}

$stmt->bind_result($hashedPassword);
$stmt->fetch();

// Check password
if (!password_verify($password, $hashedPassword)) {
    echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
    exit();
}
$stmt->close();

// Delete user
$deleteStmt = $conn->prepare("DELETE FROM users WHERE username = ?");
$deleteStmt->bind_param("s", $username);
$deleteStmt->execute();

if ($deleteStmt->affected_rows > 0) {
    echo json_encode(["status" => "success", "message" => "Your GuestPass account has been deleted successfully."]);
} else {
    echo json_encode(["status" => "error", "message" => "Deletion failed. Try again later."]);
}

$deleteStmt->close();
$conn->close();
?>
