<?php
// guardianapi/contact_send.php
declare(strict_types=1);

header("Content-Type: application/json; charset=UTF-8");

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'src/Exception.php';
require 'src/PHPMailer.php';
require 'src/SMTP.php';
require_once 'config.php';

// simple logger (same style as your alert API)
function write_log($message) {
  file_put_contents('email_debug.log', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

write_log('--- New Contact Message ---');

$raw = file_get_contents("php://input");
write_log("Received Payload: " . $raw);

$data = json_decode($raw);
if (!$data) {
  write_log('Invalid JSON');
  echo json_encode(["status" => "error", "message" => "Invalid JSON"]);
  exit();
}

$name    = trim($data->name    ?? '');
$email   = trim($data->email   ?? '');
$phone   = trim($data->phone   ?? '');
$subject = trim($data->subject ?? 'General enquiry');
$message = trim($data->message ?? '');

if ($name === '' || $email === '' || $message === '') {
  write_log('Validation Error: Missing name, email or message');
  echo json_encode(["status" => "error", "message" => "Missing name, email or message"]);
  exit();
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  write_log('Validation Error: Invalid email ' . $email);
  echo json_encode(["status" => "error", "message" => "Invalid email"]);
  exit();
}
if ($phone !== '' && !preg_match('/^[0-9+\-\s]{7,20}$/', $phone)) {
  write_log('Validation Error: Invalid phone ' . $phone);
  echo json_encode(["status" => "error", "message" => "Invalid phone format"]);
  exit();
}

$mail = new PHPMailer(true);

try {
  write_log('Configuring PHPMailer (cPanel SMTP)…');
  $mail->isSMTP();
  $mail->Host       = 'mail.parkspace.co.ke';
  $mail->SMTPAuth   = true;
  $mail->Username   = 'guestpass@parkspace.co.ke'; // same as your existing API
  $mail->Password   = 'Shemking@18';               // same as your existing API
  $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // 465 SMTPS; use ENCRYPTION_STARTTLS + 587 if you switch to TLS
  $mail->Port       = 465;

  $mail->CharSet = 'UTF-8';
  $mail->setFrom('guestpass@parkspace.co.ke', 'GuestPass Website');
  $mail->addAddress('contact_us@guestpassvms.com');     // destination inbox
  $mail->addReplyTo($email, $name); // so you can reply directly to the sender

  $mail->isHTML(true);
  $mail->Subject = 'Website Contact: ' . htmlspecialchars($subject);

  $html  = '<html><body>';
  $html .= '<h2>Website Contact Message</h2>';
  $html .= '<p><strong>Name:</strong> ' . htmlspecialchars($name) . '</p>';
  $html .= '<p><strong>Email:</strong> ' . htmlspecialchars($email) . '</p>';
  $html .= '<p><strong>Phone:</strong> ' . ($phone !== '' ? htmlspecialchars($phone) : 'N/A') . '</p>';
  $html .= '<hr />';
  $html .= '<p>' . nl2br(htmlspecialchars($message)) . '</p>';
  $html .= '</body></html>';
  $mail->Body    = $html;
  $mail->AltBody =
    "Website Contact Message\n\n" .
    "Name: $name\nEmail: $email\nPhone: " . ($phone !== '' ? $phone : 'N/A') . "\n" .
    "Subject: $subject\n\n$message\n";

  write_log('Attempting to send…');
  $mail->send();

  write_log('Sent OK');
  echo json_encode(["status" => "success", "message" => "Sent"]);
} catch (Exception $e) {
  $err = 'Mailer error: ' . $mail->ErrorInfo;
  write_log($err);
  echo json_encode(["status" => "error", "message" => $err]);
}
