<?php
require __DIR__ . '/config.php';
date_default_timezone_set('Africa/Nairobi');

header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

function pdo(): PDO {
    if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo'];
    if (function_exists('getPdoConnection')) return getPdoConnection();
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'DB not configured']); exit;
}

function auth(PDO $pdo, string $token): ?array {
    $q = $pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1");
    $q->execute([$token]);
    if ($q->fetchColumn()) return ['role'=>'admin','user_id'=>null];

    $q = $pdo->prepare("SELECT user_id FROM users WHERE token=? LIMIT 1");
    $q->execute([$token]);
    $uid = $q->fetchColumn();
    if ($uid) return ['role'=>'user','user_id'=>(int)$uid];

    return null;
}

$input = json_decode(file_get_contents('php://input'), true) ?: [];
$authz = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$token = preg_replace('/^Bearer\s+/i', '', $authz);
if (!$token) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Missing token']); exit; }

$pdo = pdo();
$who = auth($pdo, $token);
if (!$who) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Invalid token']); exit; }

$user_id = (int)($input['user_id'] ?? 0);
$org_id  = (int)($input['org_id']  ?? 0);
$site_id = (int)($input['site_id'] ?? 0);
$tag     = trim($input['tag'] ?? '');

if ($who['role']==='user' && ($user_id === 0 || $user_id !== $who['user_id'])) {
    http_response_code(403);
    echo json_encode(['success'=>false,'message'=>'Forbidden (mismatched user)']); exit;
}
if (!$user_id || !$org_id || !$site_id || $tag==='') {
    http_response_code(422);
    echo json_encode(['success'=>false,'message'=>'Missing required fields']); exit;
}

try {
    $pdo->beginTransaction();

    $row = $pdo->prepare("
        SELECT id, site_id FROM book_sessions
        WHERE user_id=? AND clock_out_time IS NULL
        FOR UPDATE
    ");
    $row->execute([$user_id]);
    $open = $row->fetch(PDO::FETCH_ASSOC);

    if (!$open) {
        $pdo->rollBack();
        http_response_code(409);
        echo json_encode(['success'=>false,'message'=>'No open session.']); exit;
    }
    if ((int)$open['site_id'] !== $site_id) {
        $pdo->rollBack();
        http_response_code(409);
        echo json_encode(['success'=>false,'message'=>'Wrong site for clock-out.']); exit;
    }

    $upd = $pdo->prepare("
        UPDATE book_sessions
        SET clock_out_tag=?, clock_out_time=NOW()
        WHERE id=?
    ");
    $upd->execute([$tag, (int)$open['id']]);

    $pdo->commit();
    echo json_encode(['success'=>true,'message'=>'Clock-out successful']);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Server error: '.$e->getMessage()]);
}
