<?php
header("Content-Type: application/json");
require_once 'config.php';

$conn = getDbConnection();
if (!$conn) {
    echo json_encode(["status"=>"error","message"=>"DB Connection failed"]);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);
if (!is_array($data['visitor_ids']) || empty($data['visitor_ids'])) {
    http_response_code(400);
    echo json_encode(["status"=>"error","message"=>"No IDs provided"]);
    exit;
}

$conn->begin_transaction();

try {
    $selectStmt = $conn->prepare("SELECT * FROM visitor_records WHERE id = ? AND is_exited=0");
    $insertStmt = $conn->prepare("
      INSERT INTO exited_visitors
      (house_id, description, name, phone_number, image_metadata, id_plates, admitted_by, otp_code)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $updateStmt = $conn->prepare("UPDATE visitor_records SET is_exited=1 WHERE id=?");

    $ids = $data['visitor_ids'];
    $count = 0;

    foreach ($ids as $id) {
        $selectStmt->bind_param("i", $id);
        $selectStmt->execute();
        $result = $selectStmt->get_result();
        $row = $result->fetch_assoc();
        if (!$row) {
            continue; // not found or already exited
        }

        // Insert
        $insertStmt->bind_param("isssssss",
            $row['house_id'],
            $row['description'],
            $row['name'],
            $row['phone_number'],
            $row['image_metadata'],
            $row['id_plates'],
            $row['admitted_by'],
            $row['otp_code']
        );
        $insertStmt->execute();

        // Update
        $updateStmt->bind_param("i", $id);
        $updateStmt->execute();

        $count++;
    }

    $conn->commit();
    echo json_encode(["status"=>"success","message"=>"Batch exit done","exited_count"=>$count]);

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
} finally {
    $selectStmt->close();
    $insertStmt->close();
    $updateStmt->close();
    $conn->close();
}
?>
