<?php
require __DIR__ . '/config2.php';
date_default_timezone_set('Africa/Nairobi');

header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

function pdo(): PDO {
    if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo'];
    return getPdoConnection(); // from config.php, will JSON-500+exit on failure
}

function auth_or_null(PDO $pdo, string $token): ?array {
    // admin?
    $q = $pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1");
    $q->execute([$token]);
    if ($q->fetchColumn()) return ['role'=>'admin','user_id'=>null];

    // user?
    $q = $pdo->prepare("SELECT user_id FROM users WHERE token=? LIMIT 1");
    $q->execute([$token]);
    $uid = $q->fetchColumn();
    if ($uid) return ['role'=>'user','user_id'=>(int)$uid];

    return null;
}

$pdo = pdo();

// ------- Temporary open access switch --------
// If you call with ?admin=1, we allow read without Authorization header.
// Optional hardening: define('OPEN_ADMIN_KEY', 'some-secret') in config.php, then require &admin_key=...
$adminOverride = (isset($_GET['admin']) && $_GET['admin'] == '1');
if ($adminOverride && defined('OPEN_ADMIN_KEY')) {
    $provided = $_GET['admin_key'] ?? '';
    if ($provided !== OPEN_ADMIN_KEY) {
        http_response_code(401);
        echo json_encode(['success'=>false,'message'=>'Invalid admin_key']);
        exit;
    }
}

$who = null;
if (!$adminOverride) {
    $authz = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    $token = preg_replace('/^Bearer\\s+/i', '', $authz);
    if (!$token) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Missing token']); exit; }
    $who = auth_or_null($pdo, $token);
    if (!$who) { http_response_code(401); echo json_encode(['success'=>false,'message'=>'Invalid token']); exit; }
} else {
    // Treat as admin for read-only listing
    $who = ['role'=>'admin','user_id'=>null];
}

// -------- Query params --------
$user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;
$site_id = isset($_GET['site_id']) ? (int)$_GET['site_id'] : null;
$date    = $_GET['date'] ?? date('Y-m-d'); // default today
$org_id  = isset($_GET['org_id']) ? (int)$_GET['org_id'] : null;
$active  = isset($_GET['active']) ? (int)$_GET['active'] : null; // 1 => only open sessions

// Normal users can only read themselves
if ($who['role'] === 'user') {
    $user_id = $who['user_id'];
}

$params = [':d' => $date];
$sql = "
SELECT s.id, s.user_id, s.org_id, s.site_id,
       s.clock_in_tag, s.clock_in_time, s.clock_out_tag, s.clock_out_time,
       u.real_name, st.site_name
FROM book_sessions s
LEFT JOIN users u ON u.user_id = s.user_id
LEFT JOIN sites st ON st.site_id = s.site_id
WHERE DATE(s.clock_in_time) = :d
";

if ($user_id !== null) { $sql .= " AND s.user_id = :uid"; $params[':uid'] = $user_id; }
if ($org_id  !== null) { $sql .= " AND s.org_id  = :oid"; $params[':oid'] = $org_id; }
if ($site_id !== null) { $sql .= " AND s.site_id = :sid"; $params[':sid'] = $site_id; }
if ($active === 1)     { $sql .= " AND s.clock_out_time IS NULL"; }

$sql .= " ORDER BY s.clock_in_time DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$sessions = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];

echo json_encode([
    'success'  => true,
    'message'  => 'OK',
    'sessions' => $sessions
]);
